unit class_db_access;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, sqlite3conn, sqldb;

type
  TDBAccess = class
    SQLite3Connection: TSQLite3Connection;
    SQLTransaction: TSQLTransaction;
  public
    constructor Create(AOwner: TComponent; Name: String = '');
    procedure Open(SQL: String = '');
    procedure Close(SQL: String = '');
  end;

var
  DBAccess: TDBAccess;

implementation

uses
  unit_config;

constructor TDBAccess.Create(AOwner: TComponent; Name: String);
begin
  if Name = '' then
    Name := Config.DatabasePath + Config.DatabaseName;
  SQLite3Connection.Create(AOwner);
  SQLTransaction.Create(AOwner);
  SQLite3Connection.DatabaseName := Name;
  SQLite3Connection.Transaction := SQLTransaction;
  SQLTransaction.DataBase := SQLite3Connection;
end;

procedure TDBAccess.Open(SQL: String);
begin
  SQLite3Connection.Open;
  SQLite3Connection.ExecuteDirect('SELECT icu_load_collation(''sk_SK'', ''slovak'')');
  if SQL <> '' then
    SQLite3Connection.ExecuteDirect(SQL);
end;

procedure TDBAccess.Close(SQL: String);
begin
  if SQL <> '' then
    SQLite3Connection.ExecuteDirect(SQL);
  SQLite3Connection.Close;
end;

end.

