unit stack_trace;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Dialogs;

const
  LogFilename: String = 'crash.log';

procedure DumpExceptionCallStack(E: Exception);
procedure CustomExceptionHandler(Sender: TObject; E: Exception);

implementation

procedure DumpExceptionCallStack(E: Exception);
var
  f: Text;
  I: integer;
  Frames: PPointer;
  Message: string;
  Report: string;
begin
  Message := 'Program exception! ' + LineEnding + 'Stacktrace:' +
    LineEnding + LineEnding;
  if E <> nil then
  begin
    Report :=
      'Date and time: ' + DateTimeToStr(Now) + LineEnding +
      'Exception class: ' + E.ClassName + LineEnding +
      'Message: ' + E.Message + LineEnding;
  end;
  Report := Report + BackTraceStrFunc(ExceptAddr);
  Frames := ExceptFrames;
  for I := 0 to ExceptFrameCount - 1 do
    Report := Report + LineEnding + BackTraceStrFunc(Frames[I]);
  ShowMessage(Message + Report);

  AssignFile(f, LogFilename);
  if FileExists(LogFilename) then
    Append(f)
  else
    Rewrite(f);
  Report := Report + LineEnding + LineEnding + LineEnding;
  Write(f, Report);
  CloseFile(f);
  Halt; // End of program execution
end;

procedure CustomExceptionHandler(Sender: TObject; E: Exception);
begin
  DumpExceptionCallStack(E);
  Halt; // End of program execution
end;

end.
