program project1;

{$mode objfpc}{$H+}

uses
  {$IFDEF UNIX}{$IFDEF UseCThreads}
  cthreads,
  {$ENDIF}{$ENDIF}
  Classes, GL, Glut
  { you can add units after this };

//---------------------------------------------------------------------
// Nastaveni souradneho systemu v zavislosti na velikosti okna
//---------------------------------------------------------------------
procedure onResize(w, h: Integer); cdecl;                    // w a h reprezentuje novou velikost okna
begin
  glViewport(0, 0, w, h);                     // viditelna oblast pres cele okno
  glMatrixMode(GL_PROJECTION);                // zacatek modifikace projekcni matice
  glLoadIdentity();                           // vymazani projekcni matice (=identita)
  glOrtho(0, w, 0, h, -1, 1);                 // mapovani abstraktnich souradnic do souradnic okna
end;

//---------------------------------------------------------------------
// Tato funkce je volana pri kazdem prekresleni okna
//---------------------------------------------------------------------
procedure onDisplay; cdecl;
begin
  glClearColor(0.0, 0.0, 0.0, 0.0);           // nastaveni mazaci barvy na cernou
  glClear(GL_COLOR_BUFFER_BIT);               // vymazani bitovych rovin barvoveho bufferu
  glColor3f(0.0, 1.0, 0.0);                // nastaveni zelene barvy pro kresleni
  glBegin(GL_TRIANGLES);                      // ted se zacnou vykreslovat trojuhelniky
    glVertex2i(200,  50);                   // souradnice prvniho vrcholu trojuhelnika
    glVertex2i( 50, 250);                   // souradnice druheho vrcholu trojuhelnika
    glVertex2i(350, 250);                   // souradnice tretiho vrcholu trojuhelnika
  glEnd();                                    // konec vykreslovani trojuhelniku
  glFlush();                                  // provedeni a vykresleni zmen
end;

//---------------------------------------------------------------------
// Tato funkce je volana pri stlaceni ASCII klavesy
//---------------------------------------------------------------------
procedure onKeyboard(key: Byte; x, y: Integer); cdecl;
begin
  if (key = 27) then halt(0);                       // pokud byla stlacena klavesa ESC, konec programu
end;

//---------------------------------------------------------------------
// Hlavni funkce konzolove aplikace
//---------------------------------------------------------------------
begin
  glutInit(@argc, @argv);                      // inicializace knihovny GLUT
  glutCreateWindow('Priklad na OpenGL cislo 1');// vytvoreni okna pro kresleni
  glutReshapeWindow(400, 400);                // zmena velikosti okna
  glutPositionWindow(100, 100);               // pozice leveho horniho rohu okna
  glutDisplayFunc(@onDisplay);                 // registrace funkce volane pri prekreslovani okna
  glutReshapeFunc(@onResize);                  // registrace funkce volane pri zmene velikosti okna
  glutKeyboardFunc(@onKeyboard);               // registrace funkce volani pri stlaceni klavesy
  glutMainLoop();                             // nekonecna smycka, kde se volaji zaregistrovane funkce
  halt(0);                                   // navratova hodnota vracena operacnimu systemu
end.

