unit Unit1;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, OpenGLContext, Forms, Controls, Graphics,
  Dialogs, StdCtrls;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    OpenGLControl1: TOpenGLControl;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure OpenGLControl1KeyPress(Sender: TObject; var Key: char);
    procedure OpenGLControl1Paint(Sender: TObject);
    procedure OpenGLControl1Resize(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  Form1: TForm1;

implementation

uses GL;

{$R *.lfm}

{ TForm1 }

procedure TForm1.Button1Click(Sender: TObject);
begin
  OpenGLControl1Paint(Self);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  //glutInit(@argc, @argv);                      // inicializace knihovny GLUT
  //glutCreateWindow('Priklad na OpenGL cislo 1');// vytvoreni okna pro kresleni
  //glutReshapeWindow(400, 400);                // zmena velikosti okna
  //glutPositionWindow(100, 100);               // pozice leveho horniho rohu okna
  //glutDisplayFunc(@onDisplay);                 // registrace funkce volane pri prekreslovani okna
  //glutReshapeFunc(@onResize);                  // registrace funkce volane pri zmene velikosti okna
  //glutKeyboardFunc(@onKeyboard);               // registrace funkce volani pri stlaceni klavesy
  //glutMainLoop();                             // nekonecna smycka, kde se volaji zaregistrovane funkce
  //halt(0);                                   // navratova hodnota vracena operacnimu systemu
end;

procedure TForm1.OpenGLControl1KeyPress(Sender: TObject; var Key: char);
begin
  if (Key = #27) then halt(0);                       // pokud byla stlacena klavesa ESC, konec programu
end;

procedure TForm1.OpenGLControl1Paint(Sender: TObject);
begin
  glClearColor(0.0, 0.0, 0.0, 0.0);           // nastaveni mazaci barvy na cernou
  glClear(GL_COLOR_BUFFER_BIT);               // vymazani bitovych rovin barvoveho bufferu
  glColor3f(0.0, 1.0, 0.0);                // nastaveni zelene barvy pro kresleni
  glBegin(GL_TRIANGLES);                      // ted se zacnou vykreslovat trojuhelniky
    glVertex2i(200,  50);                   // souradnice prvniho vrcholu trojuhelnika
    glVertex2i( 50, 250);                   // souradnice druheho vrcholu trojuhelnika
    glVertex2i(350, 250);                   // souradnice tretiho vrcholu trojuhelnika
  glEnd();                                    // konec vykreslovani trojuhelniku
  glFlush();                                  // provedeni a vykresleni zmen
  OpenGLControl1.SwapBuffers;
end;

procedure TForm1.OpenGLControl1Resize(Sender: TObject);
begin
  glViewport(0, 0, OpenGLControl1.Width, OpenGLControl1.Height);                     // viditelna oblast pres cele okno
  glMatrixMode(GL_PROJECTION);                // zacatek modifikace projekcni matice
  glLoadIdentity();                           // vymazani projekcni matice (=identita)
  glOrtho(0, OpenGLControl1.Width, 0, OpenGLControl1.Height, -1, 1);                 // mapovani abstraktnich souradnic do souradnic okna
end;

end.

