/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

var app = angular.module('ionicApp', ['ionic']);



app.directive('validNumberBin', function() {
  return {
    require: '?ngModel',
    link: function(scope, element, attrs, ngModelCtrl) {
      if(!ngModelCtrl) {
        return; 
      }
      ngModelCtrl.$parsers.push(function(val) {
        var clean = val.replace( /[^01]+/g, '');
        if (val !== clean) {
          ngModelCtrl.$setViewValue(clean);
          ngModelCtrl.$render();
        }
        return clean;
      });
      
      element.bind('keypress', function(event) {
        if(event.keyCode === 32) {
          event.preventDefault();
        }
      });
    }
  };
});
        
app.directive('validNumberDec', function() {
  return {
    require: '?ngModel',
    link: function(scope, element, attrs, ngModelCtrl) {
      if(!ngModelCtrl) {
        return; 
      }
      
      ngModelCtrl.$parsers.push(function(val) {
        var clean = val.replace( /[^0-9]+/g, '');
        if (val !== clean) {
          ngModelCtrl.$setViewValue(clean);
          ngModelCtrl.$render();
        }
        return clean;
      });
      
      element.bind('keypress', function(event) {
        if(event.keyCode === 32) {
          event.preventDefault();
        }
      });
    }
  };
});

app.directive('validNumberHex', function() {
  return {
    require: '?ngModel',
    link: function(scope, element, attrs, ngModelCtrl) {
      if(!ngModelCtrl) {
        return; 
      }
      
      ngModelCtrl.$parsers.push(function(val) {
        var clean = val.replace( /[^0-9ABCDEFabcdef]+/g, '');
        if (val !== clean) {
          ngModelCtrl.$setViewValue(clean);
          ngModelCtrl.$render();
        }
        return clean;
      });
      
      element.bind('keypress', function(event) {
        if(event.keyCode === 32) {
          event.preventDefault();
        }
      });
    }
  };
});

app.filter('range', function() {
 return function(input, min, max) {
 min = parseInt(min); //Make string input int
 max = parseInt(max);
 for (var i=min; i<max; i++)
 input.push(i);
 return input;
 };
});

app.controller('tableController', function($scope){  
    $scope.max16 = false;   $scope.max32 = true;    $scope.max64 = false;    $scope.max128 = false;    
    $scope.Max = 32;
    
    $scope.convert2 = function(value){
        return parseInt(value,10).toString(2);
    };
    
    $scope.convert16 = function(value){
        return parseInt(value,10).toString(16).toUpperCase();
    };
    
    $scope.convertBCD = function(value){
        var S; var BCD; var X; var numberBCD;
        S = ""; BCD = ""; X = ""; numberBCD = "";
        S = value.toString(10);
        for (var i=0; i<S.length; i++){
            X = "0000" + (parseInt(S[i], 10)).toString(2);
            X = X.substring(X.length, X.length-4);
            BCD += X;
        };
        numberBCD = BCD;

        return numberBCD;
    };
    
    
    $scope.setMax = function(value){
        $scope.Max = value;
        if (value===16) {$scope.max16 = true; $scope.max32 = false; $scope.max64 = false; $scope.max128 = false;};
        if (value===32) {$scope.max16 = false; $scope.max32 = true; $scope.max64 = false; $scope.max128 = false; };
        if (value===64) {$scope.max16 = false;  $scope.max32 = false; $scope.max64 = true;  $scope.max128 = false;};
        if (value===128) {$scope.max16 = false; $scope.max32 = false; $scope.max64 = false; $scope.max128 = true;};
    };

});

app.controller('numberController', function($scope){
    
    $scope.language = {};
    $scope.language = {en: {}, es: {}, cz: {}};
    
    $scope.language = {
        en: {is: "en", 1: "Numeral systems", 2: "version", 3: " English ", 4: "Conversion", 5: "Table of values",
                        6: "Application", 7: "not\u00A0calculated", 8: "", 9: "",
                        10: "", 11: "", 12: "", 13: "", 14: ""}, 
        es: {is: "es", 1: "Sistemas de numeración", 2: "versión", 3: " Español ", 4: "Conversión", 5: "Tabla de valores",
                        6: "Aplicación", 7: "no\u00A0calculado", 8: "", 9: "",
                        10: "", 11: "", 12: "", 13: "", 14: ""}, 
        cz: {is: "cz", 1: "Číselné soustavy", 2: "verze", 3: " Česky ", 4: "Převod", 5: "Tabulka hodnot",
                        6: "Aplikace", 7: "nelze\u00A0určit", 8: "", 9: "",
                        10: "", 11: "", 12: "", 13: "", 14: ""}
    };    
    
    $scope.lang = $scope.language.en;
    
    $scope.changeLanguage = function(){
        if ($scope.lang.is === "en") {$scope.lang = $scope.language.es; return;};
        if ($scope.lang.is === "es") {$scope.lang = $scope.language.cz; return;};        
        if ($scope.lang.is === "cz") {$scope.lang = $scope.language.en; return;};        
    };   
    

    $scope.state = "home";
    $scope.fromBin = true;  $scope.fromDec = false; $scope.fromHex = false;
    $scope.stateConvert = "bin";
    $scope.number = null;   $scope.number2 = null;   $scope.number10 = null;   $scope.number16 = null;   
    $scope.numberDEC = null;   $scope.numberBCD = null;   
    $scope.error = true; $scope.errorBCD = true;

    $scope.showHome = function(){
        $scope.state = "home";
    };

    $scope.showConvert = function(){
        $scope.state = "convert";
    };

    $scope.showConvertBCD = function(){
        $scope.state = "convertBCD";    $scope.errorBCD = true;
        $scope.numberDEC = null;   
    };

    $scope.showTable = function(){
        $scope.state = "table";
    };

    $scope.showAbout = function(){
        $scope.state = "about";
    };
    
    $scope.showConvertBin = function(){
        $scope.stateConvert = "bin";    $scope.error = true;
        $scope.number = null;   $scope.number2 = null;   $scope.number10 = null;   $scope.number16 = null;
    };
    
    $scope.showConvertDec = function(){
        $scope.stateConvert = "dec";    $scope.error = true;
        $scope.number = null;   $scope.number2 = null;   $scope.number10 = null;   $scope.number16 = null;   
    };    

    $scope.showConvertHex = function(){
        $scope.stateConvert = "hex";    $scope.error = true;
        $scope.number = null;   $scope.number2 = null;   $scope.number10 = null;   $scope.number16 = null;   
    };

    $scope.convertSwitch = function(value){
        if (value==="bin") {$scope.fromBin = true;  $scope.fromDec = false; $scope.fromHex = false; $scope.showConvertBin();};
        if (value==="dec") {$scope.fromBin = false;  $scope.fromDec = true; $scope.fromHex = false; $scope.showConvertDec();};
        if (value==="hex") {$scope.fromBin = false;  $scope.fromDec = false; $scope.fromHex = true; $scope.showConvertHex();};        
    };

    $scope.convertNumber = function(value){
        if (($scope.number===null) || ($scope.number===NaN) || ($scope.number==="")) {$scope.error = true; $scope.number2 = null; $scope.number10 = null; $scope.number16 = null;return;};
        $scope.error = false;
        if (value==="bin") {$scope.number10 = parseInt($scope.number,2).toString(10);   $scope.number16 = parseInt($scope.number,2).toString(16).toUpperCase();};
        if (value==="dec") {$scope.number2 = parseInt($scope.number,10).toString(2);   $scope.number16 = parseInt($scope.number,10).toString(16).toUpperCase();};
        if (value==="hex") {$scope.number2 = parseInt($scope.number,16).toString(2);   $scope.number10 = parseInt($scope.number,16).toString(10);}; 
    };

    $scope.convertNumberBCD = function(value){
        if (($scope.numberDEC===null) || ($scope.numberDEC===NaN) || ($scope.numberDEC==="")) {$scope.errorBCD = true; $scope.numberBCD = null; return;};
        $scope.errorBCD = false;
        var S; var BCD; var X;
        S = ""; BCD = ""; X = "";
        S = value.toString(10);
        for (var i=0; i<S.length; i++){
            X = "0000" + (parseInt(S[i], 10)).toString(2);
            X = X.substring(X.length, X.length-4);
            BCD += X;
        };
        $scope.numberBCD = BCD;
    };


});
