var app = angular.module('app', ['ionic', 'ui.bootstrap']);

app.directive("svgMark", function(){
   return {
     restrict: "E",
     replace: true,
     scope: {
         x: "@",
         y: "@",
         value: "@"
     },
     templateNamespace: 'svg',
     template: "<g transform='translate({{x}}, {{y}})'>\n\
                <circle ng-attr-cx='{{x}}' ng-attr-cy='{{y-2.5}}' r='6' stroke='red' fill='white' />\n\
                <text ng-attr-x='{{x-2}}' ng-attr-y='{{y}}' font-size='7' font-style='normal' font-weight='normal' stroke='red' stroke-width='0.5px'>{{value}}</text>\n\
                </g>"
   }; 
});

app.directive("svgDc", function(){
    return {
        restrict: "E",
        replace: true,
        scope: {
            x: "=",
            y: "=",
            rot: "="
        },
        templateNamespace: 'svg',
        template: "<g transform='translate({{x}}, {{y}}) rotate({{rot}}, 0, 10)'>\n\
            <line x1='0' y1='10' x2='10' y2='10' stroke='black'/>\n\
            <line x1='4' y1='5' x2='8' y2='5' stroke='black'/>\n\
            <line x1='6' y1='3' x2='6' y2='7' stroke='black'/>\n\
            <circle cx='17.5' cy='10' r='8' stroke='black' fill='none'/>\n\
            <line x1='28' y1='3' x2='28' y2='7' stroke='black'/>\n\
            <line x1='16' y1='7' x2='16' y2='13' stroke='black'/>\n\
            <line x1='19' y1='7' x2='19' y2='13' stroke='black'/>\n\\n\
            <line x1='25' y1='10' x2='35' y2='10' stroke='black'/>\n\
            </g>"
    };
});

app.directive("svgVmeter", function(){
    return {
        restrict: "E",
        replace: true,
        scope: {
            x: "=",
            y: "=",
            rot: "="
        },
        templateNamespace: 'svg',
        template: "<g transform='translate({{x}}, {{y}}) rotate({{rot}}, 0, 10)'>\n\
            <line x1='0' y1='10' x2='10' y2='10' stroke='black'/>\n\
            <circle cx='17.5' cy='10' r='8' stroke='black' fill='none'/>\n\
            <line x1='25' y1='10' x2='35' y2='10' stroke='black'/>\n\
            <text x='14' y='14' font-size='11'>V</text>\n\
            </g>"
    };
});

app.directive("svgAmeter", function(){
    return {
        restrict: "E",
        replace: true,
        scope: {
            x: "=",
            y: "=",
            rot: "="
        },
        templateNamespace: 'svg',
        template: "<g transform='translate({{x}}, {{y}}) rotate({{rot}}, 0, 10)'>\n\
            <line x1='0' y1='10' x2='10' y2='10' stroke='black'/>\n\
            <circle cx='17.5' cy='10' r='8' stroke='black' fill='none'/>\n\
            <line x1='25' y1='10' x2='35' y2='10' stroke='black'/>\n\
            <text x='14' y='14' font-size='11'>A</text>\n\
            </g>"
    };
});

app.directive("svgNode", function(){
    return {
        restrict: "E",
        replace: true,
        scope: {
            x: "=",
            y: "="
        },
        templateNamespace: 'svg',
        template: "<g transform='translate({{x}}, {{y}})'>\n\
            <circle cx='0' cy='10' r='2' stroke='black'/>\n\
            </g>"
    };
});


app.directive("svgWireX", function(){
    return {
        restrict: "E",
        replace: true,
        scope: {
            x: "=",
            y: "=",
            rot: "=",
            length: "="
        },
        templateNamespace: 'svg',
        template: "<g transform='translate({{x}}, {{y}}) rotate({{rot}}, 0, 10)'>\n\
            <line x1='0' y1='10' ng-attr-x2='{{length}}' y2='10' stroke='black'/>\n\
            </g>"
    };
});

app.directive("svgWireY", function(){
    return {
        restrict: "E",
        replace: true,
        scope: {
            x: "=",
            y: "=",
            rot: "=",
            length: "="
        },
        templateNamespace: 'svg',
        template: "<g transform='translate({{x}}, {{y}}) rotate({{rot}}, 0, 10)'>\n\
            <line x1='0' y1='10' x2='0' ng-attr-y2='{{10+length}}' stroke='black'/>\n\
            </g>"
    };
});

app.directive("svgD", function(){
    return {
        restrict: "E",
        replace: true,
        scope: {
            x: "=",
            y: "=",
            rot: "="
        },
        templateNamespace: 'svg',
        template: "<g transform='translate({{x}}, {{y}}) rotate({{rot}}, 0, 10)'>\n\
            <line x1='0' y1='10' x2='45' y2='10' stroke='black'/>\n\
            <polygon points='15, 0 15, 20 35, 10' stroke='black' fill='none' />\n\
            <line x1='35' y1='0' x2='35' y2='20' stroke='black'/> \n\
            </g>"
    };
});

app.directive("svgR", function(){
    return {
        restrict: "E",
        replace: true,
        scope: {
            x: "=",
            y: "=",
            rot: "="
        },
        templateNamespace: 'svg',
        template: "<g transform='translate({{x}}, {{y}}) rotate({{rot}}, 0, 10)'>\n\
            <line x1='0' y1='10' x2='10' y2='10' stroke='black'/>\n\
            <rect x='10' y='5' width='25' height='10' stroke='black' fill='none' />\n\
            <line x1='35' y1='10' x2='45' y2='10' stroke='black'/>\n\
            </g>"
    };
});

app.directive("svgC", function(){
    return {
        restrict: "E",
        replace: true,
        scope: {
            x: "=",
            y: "=",
            rot: "="
        },
        templateNamespace: 'svg',
        template: "<g transform='translate({{x}}, {{y}}) rotate({{rot}}, 0, 10)'>\n\
            <line x1='0' y1='10' x2='10' y2='10' stroke='black'/>\n\
            <line x1='10' y1='0' x2='10' y2='20' stroke='black'/>\n\
            <line x1='20' y1='0' x2='20' y2='20' stroke='black'/>\n\
            <line x1='20' y1='10' x2='30' y2='10' stroke='black'/>\n\
            </g>"
    };
});

/*
app.directive("svgR", function(){
    return {
        restrict: "E",
        replace: true,
        scope: {
            x: "=",
            y: "="
        },
        templateNamespace: 'svg',
        template: "<g transform='translate({{x}}, {{y}})'><line x1='0' y1='10' x2='10' y2='10' stroke='black'/></g>"
//        template: '<line x1="0" y1="10" x2="10" y2="10" stroke="black"/>'
    };
});
*/

app.directive("tdData", function(){
    return {
        restrict: "A",
        scope: {
            data: "="
        },
        template: "<td>{{data}}</td>"
    };
});

/*
app.directive('trByteVar', function(){
    return {
      restrict: "A",
      replace: true,
      scope: {
          value: "="
      },
      link: function($scope){
          $scope.$watch("value", getByte(), false);
      },
      template: "<tr><td>{{Bit(7)}}</td><td>{{Bit(6)}}</td><td>{{Bit(5)}}</td><td>{{Bit(4)}}</td><td>{{Bit(3)}}</td><td>{{Bit(2)}}</td><td>{{Bit(1)}}</td><td>{{Bit(0)}}</td></tr>",
      controller: function($scope){
          getByte = function(){
            var Byte = [];
            if (!($scope.value === parseInt($scope.value)) || ($scope.value < 0) || ($scope.value > 255) ) {$scope.Byte = ["-", "-", "-", "-", "-", "-", "-", "-"]; return;};

            for (var i = 7; i>-1; i--) {if ($scope.value >= Math.pow(2, i)) {Byte[i] = 1; $scope.value = $scope.value - Math.pow(2, i);} else {Byte[i] = 0;};};
            $scope.Byte = Byte;

            $scope.Bit = function(index){
                return $scope.Byte[index];
              };
          };

          $scope.$watch("value", getByte(), false);

        }
    };
});
*/


app.directive('trByte', function(){
    return {
      restrict: "A",
      replace: true,
      scope: {
          value: "="
      },
      template: "<tr><td>{{Byte[7]}}</td><td>{{Byte[6]}}</td><td>{{Byte[5]}}</td><td>{{Byte[4]}}</td><td>{{Byte[3]}}</td><td>{{Byte[2]}}</td><td>{{Byte[1]}}</td><td>{{Byte[0]}}</td></tr>",
      controller: function($scope){
        var Byte = [];
        if (!($scope.value === parseInt($scope.value)) || ($scope.value < 0) || ($scope.value > 255) ) {$scope.Byte = ["-", "-", "-", "-", "-", "-", "-", "-"]; return;};
        
        for (var i = 7; i>-1; i--) {if ($scope.value >= Math.pow(2, i)) {Byte[i] = 1; $scope.value = $scope.value - Math.pow(2, i);} else {Byte[i] = 0;};};
        $scope.Byte = Byte;
        }
    };
});


app.directive('validNumberBin', function() {
  return {
    require: '?ngModel',
    link: function(scope, element, attrs, ngModelCtrl) {
      if(!ngModelCtrl) {
        return; 
      }
      ngModelCtrl.$parsers.push(function(val) {
        var clean = val.replace( /[^01]+/g, '');
        if (val !== clean) {
          ngModelCtrl.$setViewValue(clean);
          ngModelCtrl.$render();
        }
        return clean;
      });
      
      element.bind('keypress', function(event) {
        if(event.keyCode === 32) {
          event.preventDefault();
        }
      });
    }
  };
});
        
app.directive('validNumberDec', function() {
  return {
    require: '?ngModel',
    link: function(scope, element, attrs, ngModelCtrl) {
      if(!ngModelCtrl) {
        return; 
      }
      
      ngModelCtrl.$parsers.push(function(val) {
        var clean = val.replace( /[^0-9]+/g, '');
        if (val !== clean) {
          ngModelCtrl.$setViewValue(clean);
          ngModelCtrl.$render();
        }
        return clean;
      });
      
      element.bind('keypress', function(event) {
        if(event.keyCode === 32) {
          event.preventDefault();
        }
      });
    }
  };
});


/*
app.directive("goTop", function(){
   return {
       restrict: "A",
       link: function(){
//           location.hash = "";
       }
   };
});
*/

app.controller("binaryController", function($scope){
    $scope.number_2 = null;
    $scope.number_2_10 = "not calculated";
    $scope.number_2_error = true;
    $scope.number_10 = null;
    $scope.number_10_2 = "not calculated";
    $scope.number_10_error = true;
    $scope.number_Byte = null;
    $scope.Bits = ["-", "-", "-", "-", "-", "-", "-", "-"];
//   $scope.Bits = []; 
    
    $scope.convertNumberBin = function(){
        if (($scope.number_2 === null) || ($scope.number_2 === "")) {$scope.number_2_error = true; return;};
        $scope.number_2_error = false;
        $scope.number_2_10 = parseInt($scope.number_2, 2).toString(10);
    };
    $scope.resetNumber_2 = function(){
        $scope.number_2 = null;
        $scope.number_2_10 = "not calculated";
        $scope.number_2_error = true;
    };
    $scope.convertNumberDec = function(){
        if (($scope.number_10 === null) || ($scope.number_10 === "")) {$scope.number_10_error = true; return;};
        $scope.number_10_error = false;
        $scope.number_10_2 = parseInt($scope.number_10, 10).toString(2);
    };
    $scope.resetNumber_10 = function(){
        $scope.number_10 = null;
        $scope.number_10_2 = "not calculated";
        $scope.number_10_error = true;
    };
    

    $scope.Byte = [0, 0, 0, 0, 0, 0, 0, 0];
    $scope.invertBit = function(value){
        $scope.Byte[value] = ($scope.Byte[value] + 1) % 2;
    };
    $scope.binValue = function(){
        var result = "";
        for (var i = 7; i > -1; i--) result += $scope.Byte[i];
        return result;
    };
    $scope.decValue = function(){
        var result = 0;
        for (var i = 7; i > -1; i--) result += $scope.Byte[i]*Math.pow(2, i);
        return result;
    };
    $scope.resetByte = function(){
        $scope.Byte = [0, 0, 0, 0, 0, 0, 0, 0];
    };
    
    $scope.byteToBits = function(value){
        var Bits=[];
        if (!(value == parseInt(value)) || (value < 0) || (value > 255) ) {$scope.Bits = ["-", "-", "-", "-", "-", "-", "-", "-"]; return;};
        
        for (var i = 7; i>-1; i--) {if (value >= Math.pow(2, i)) {Bits[i] = 1; value = value - Math.pow(2, i);} else {Bits[i] = 0;};};
        $scope.Bits = Bits;
    };
    
});


app.controller("signalController", function($scope){
    $scope.sampling = 0;
});

app.controller("logVariableController", function($scope){
    $scope.logA = false;
});

app.controller("logFunctionController", function($scope){
    $scope.logA = false;
    $scope.logB = false;
});

app.controller("logGateController", function($scope){
    $scope.logA = false;
    $scope.logB = false;
});


app.controller("appController", function($scope, $state){    
    
    $scope.labSignVisible = function(){
        return ($state.is("Signal") || $state.is("Binary") || $state.is("Log_variable") || $state.is("Log_function") || $state.is("Log_gate"));
    };
    
    $scope.settings = {};
    $scope.settings.stringFunctionIs = "Y";   //  "Y"     "F
    $scope.settings.stringLogIs = "01";     //  "01"    "LH"    "FT"
    $scope.settings.stringLog0 = function(){
        if ($scope.settings.stringLogIs === "01") {return "0";};
        if ($scope.settings.stringLogIs === "LH") {return "L";};
        if ($scope.settings.stringLogIs === "FT") {return "F";};
    };
    $scope.settings.stringLog1 = function(){
        if ($scope.settings.stringLogIs === "01") {return "1";};
        if ($scope.settings.stringLogIs === "LH") {return "H";};
        if ($scope.settings.stringLogIs === "FT") {return "T";};        
    };
    $scope.settings.stringFunction = function(){
        if ($scope.settings.stringFunctionIs === "Y") {return "Y";};
        if ($scope.settings.stringFunctionIs === "F") {return "F";};
    };
    $scope.settings.setStringFunction = function(value){
        if (value === 'Y') {$scope.settings.stringFunctionIs = "Y";};
        if (value === 'F') {$scope.settings.stringFunctionIs = "F";};
    };
    $scope.settings.setStringLogState = function(value){
        if (value === '01') {$scope.settings.stringLogIs = "01";};
        if (value === 'LH') {$scope.settings.stringLogIs = "LH";};
        if (value === 'FT') {$scope.settings.stringLogIs = "FT";};
    };
    
    $scope.stringOR_AB = function(logA, logB){
        var result;
        result = (logA || logB);
        if ($scope.settings.stringLogIs === "01") {return result ? "1" : "0";};
        if ($scope.settings.stringLogIs === "LH") {return result ? "H" : "L";};
        if ($scope.settings.stringLogIs === "FT") {return result ? "T" : "F";};
    };
    
    $scope.stringNOR_AB = function(logA, logB){
        var result;
        result = (logA || logB);
        if ($scope.settings.stringLogIs === "01") {return result ? "0" : "1";};
        if ($scope.settings.stringLogIs === "LH") {return result ? "L" : "H";};
        if ($scope.settings.stringLogIs === "FT") {return result ? "F" : "T";};
    };
    
    $scope.stringAND_AB = function(logA, logB){
        var result;
        result = (logA && logB);
        if ($scope.settings.stringLogIs === "01") {return result ? "1" : "0";};
        if ($scope.settings.stringLogIs === "LH") {return result ? "H" : "L";};
        if ($scope.settings.stringLogIs === "FT") {return result ? "T" : "F";};
    };
    
    $scope.stringNAND_AB = function(logA, logB){
        var result;
        result = (logA && logB);
        if ($scope.settings.stringLogIs === "01") {return result ? "0" : "1";};
        if ($scope.settings.stringLogIs === "LH") {return result ? "L" : "H";};
        if ($scope.settings.stringLogIs === "FT") {return result ? "F" : "T";};
    };

    $scope.stringXOR_AB = function(logA, logB){
        var result;
        result = (logA !== logB);
        if ($scope.settings.stringLogIs === "01") {return result ? "1" : "0";};
        if ($scope.settings.stringLogIs === "LH") {return result ? "H" : "L";};
        if ($scope.settings.stringLogIs === "FT") {return result ? "T" : "F";};
    };

    $scope.stringXNOR_AB = function(logA, logB){
        var result;
        result = (logA !== logB);
        if ($scope.settings.stringLogIs === "01") {return result ? "0" : "1";};
        if ($scope.settings.stringLogIs === "LH") {return result ? "L" : "H";};
        if ($scope.settings.stringLogIs === "FT") {return result ? "F" : "T";};
    };
    
});
app.config(["$urlRouterProvider", "$stateProvider", "$ionicConfigProvider", "$compileProvider", function($urlRouterProvider, $stateProvider, $ionicConfigProvider, $compileProvider){
            $compileProvider.debugInfoEnabled(false);
            $ionicConfigProvider.views.maxCache(30);
            $ionicConfigProvider.views.forwardCache(true);
            $urlRouterProvider.otherwise("/");
            $stateProvider
                    .state("home", {
                        url: "/", 
                        templateUrl: "templates/home.html"
                    })
                    .state("home_Level_B", {
                        url: "/home_Level_B", 
                        templateUrl: "templates/home_Level_B.html"
                    })
                    .state("home_Level_A", {
                        url: "/home_Level_A", 
                        templateUrl: "templates/home_Level_A.html"
                    })
                    .state("Settings", {
                        url: "/Settings", 
                        templateUrl: "templates/Settings.html"
                    })
                    .state("Signal", {
                        url: "/Signal", 
                        templateUrl: "templates/Signal.html"
                    })
                    .state("Binary", {
                        url: "/Binary", 
                        templateUrl: "templates/Binary.html"
//                        ,
//                        controller: "binaryController"
                    })
                    .state("Log_variable", {
                        url: "/Log_variable",
                        templateUrl: "templates/Log_variable.html"
                    })
                    .state("Log_function", {
                        url: "/Log_function", 
                        templateUrl: "templates/Log_function.html"
                    })
                    .state("Log_gate", {
                        url: "/Log_gate", 
                        templateUrl: "templates/Log_gate.html"
                    })
                    .state("Log_circuit", {
                        url: "/Log_circuit", 
                        templateUrl: "templates/Log_circuit.html"
                    })
                    .state("Bool", {
                        url: "/Bool", 
                        templateUrl: "templates/Bool.html"
                    })
                    .state("De_Morgan", {
                        url: "/De_Morgan", 
                        templateUrl: "templates/De_Morgan.html"
                    })
                    .state("Karnough", {
                        url: "/Karnough", 
                        templateUrl: "templates/Karnough.html"
                    })
                    .state("Wikipedia", {
                        url: "/Wikipedia", 
                        templateUrl: "templates/Wikipedia.html"
                    })
                    .state("apps", {
                        url: "/apps",
                        templateUrl: "templates/apps.html"
                    });
            }]
);