/**
 * 
 */
package sklad.model;

import java.util.Comparator;

/**
 * Kompartor dvou poloek, kter zjemci porovn dv poloky mezi sebou dle
 * njakho kritria. Bude pouit v algoritmu azen Collections.sort()
 * 
 * @author Tom Kozel
 * 
 */
public class KomparatorPolozek implements Comparator<SkladPolozka> {
	// veejn konstanty pro nroznj vbr typu tdn pi voln
	// konstruktoru
	public static final int DLE_CENY = 0;
	public static final int DLE_NAZVU = 1;
	private int typ = 0;

	public KomparatorPolozek() {
	}

	/**
	 * Konstruktor, ktery nastav typ azen poloek
	 * 
	 * @param typ
	 *            typ azen
	 */
	public KomparatorPolozek(int typ) {
		this.typ = typ;
	}

	/**
	 * Porovnv dv poloky mezi sebou dle kritria urenho v atributu typ
	 */
	public int compare(SkladPolozka o1, SkladPolozka o2) {
		switch (typ) {
		case 0:
			return (int) (o1.getCena() - o2.getCena());
		case 1:
			return o1.getNazev().compareToIgnoreCase(o2.getNazev());
		}
		return 0;
	}

}
