package sklad.model;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Sklad. Implementovn jako potomek kolekce ArrayList.
 * 
 * @author Tom Kozel, Filip Maly
 */
public class Sklad extends ArrayList<SkladPolozka> {
	
	/**
	 * Vyhledn vech poloek dle libovoln sti nzvu. Vrac seznam
	 * vech vyhovujcch poloek nebo null, pokud nen nic nalezeno.
	 * @param s hledan text
	 * @return Vector instance tdy Vector - seznam nalezench poloek
	 */
	public List<SkladPolozka> hledej(String s) {
		List<SkladPolozka> vysl = new ArrayList<SkladPolozka>(); //pro uloen nalezench poloek
		String nazev;
		    
		s = s.toUpperCase();	// ve pevedeme na velk psmena
		
		for (SkladPolozka pol : this ) { //bylo by mon pout i Itertor
			// Zjisti nzev a pevedeme ho zrove na velk psmena.
			nazev = pol.getNazev().toUpperCase();
			if (nazev.indexOf(s)!=-1) {	//je v nzvu obsaen hledan text?
				
				vysl.add(pol);		//ano -> vlo odkaz na i-t prvek ze 
										//skladu tak do vektoru nalezench pol.
			}
		}
		
		// Vra seznam nalezench poloek nebo null, pokud nic nenajdeme.
		return (vysl.size()!=0)?vysl:null;
	}
	
	/**
	 * Vpis vech poloek do konzole.
	 * @param out
	 */
	public void vypis(PrintStream out) {
		out.println();
		out.println();
		out.println("--------------------------------------------------");
		out.println("VPIS SKLADOVCH POLOEK--------------------------");
		for (SkladPolozka p : this) {
			p.vypis(System.out);
		}
	}
	
	/**
	 * Seazen poloek skladu podle zadanho kritria.
	 * @param typRazeni
	 */
	public void sort(int typRazeni) {
		
		// Zavolme algoritmus tdn kolekc, kter je soust balku
		// java.util
		// Tdme instanci tto tdy (this) pomoc instance kompartoru KomparatorPolozek
		Collections.sort(this,new KomparatorPolozek(typRazeni)); 
	}
}
