package sklad.model;

import java.io.PrintStream;
import java.io.Serializable;
import java.text.NumberFormat;

/**
 * Skladov poloka. Implementuje rozhran Serializable a dky tomu je mon j
 * uloit pmo do ObjectOutputStreamu. Je evidovna v kolekci sklad.
 * 
 * @author Tom Kozel, Filip Maly
 */

public class SkladPolozka implements Serializable {
	private String nazev;
	private double cena;

	/**
	 * Konstruktor bez parametr
	 */
	public SkladPolozka() {
		nazev = null;
		cena = 0;
	}

	/**
	 * Konstruktor se dvma parametry
	 * 
	 * @param nazev
	 * @param cena
	 */
	public SkladPolozka(String nazev, double cena) {
		this.nazev = nazev;
		this.cena = cena;
	}

	/**
	 * Selektor nzvu
	 * 
	 * @return cena
	 */
	public double getCena() {
		return cena;
	}

	/**
	 * Modifiktor nzvu
	 * 
	 * @param d
	 *            cena
	 */
	public void setCena(double d) {
		cena = d;
	}

	/**
	 * Selektor nzvu
	 * 
	 * @return nazev
	 */
	public String getNazev() {
		return nazev;
	}

	/**
	 * Modifiktor nzvu
	 * 
	 * @param string
	 *            nazev
	 */
	public void setNazev(String string) {
		nazev = string;
	}

	/**
	 * Vpis poloky
	 * 
	 * @param out
	 */
	public void vypis(PrintStream out) {
		NumberFormat fmt = NumberFormat.getCurrencyInstance();
		out.println(nazev + ", " + fmt.format(cena));
	}

}
