package sklad.app;

import java.io.*;
import java.util.*;

import sklad.model.KomparatorPolozek;
import sklad.model.Sklad;
import sklad.model.SkladPolozka;
import sklad.utils.Vstupy;

/**
 * Ovldac program skladovho hospodstv.
 * 
 * @author Tom Kozel, Filip Maly
 */
public class SkladApp {
	private Sklad sklad = null;

	public void start() {
		sklad = new Sklad();
		zobrazMenu();
	}

	/**
	 * Vytvori menu a zepta se uzivatele na volbu
	 */
	public void zobrazMenu() {
		char volba = ' ';

		System.out
				.println("<<<------------------S.K.L.A.D------------------>>>");

		do {
			System.out.println();
			System.out.println();
			System.out.println("--------- MENU ---------");
			System.out.println("P - Pidat poloku");
			System.out.println("V - Vypsat poloky");
			System.out.println("F - Vyhledat (Find) dle nzvu");
			System.out.println("N - Seadit dle Nzvu");
			System.out.println("C - Seadit dle Ceny");
			System.out.println("L - Nast (Load)");
			System.out.println("U - Uloit");
			System.out.println("K - Konec");
			System.out.println();
			volba = Character.toUpperCase(Vstupy.ctiChar("Vae volba: "));
			System.out.println();

			switch (volba) {

			case 'P': // nov poloka
				SkladPolozka p = new SkladPolozka(
						Vstupy.ctiString("Zadejte nzev poloky: "),
						Vstupy.ctiDouble("Zadejte cenu poloky: "));
				sklad.add(p);
				break;
			case 'V': // vypsat ve
				sklad.vypis(System.out);
				break;
			case 'F': // Vyhledat
				hledejPolozky();
				break;
			case 'N': // tdn dle nazvu
				sklad.sort(KomparatorPolozek.DLE_NAZVU);
				sklad.vypis(System.out);
				break;
			case 'C': // tdn dle ceny
				sklad.sort(KomparatorPolozek.DLE_CENY);
				sklad.vypis(System.out);
				break;
			case 'L': // naten ze souboru
				nacti();
				break;
			case 'U': // uloen do s.
				uloz();
				break;

			default:
				break;
			}

		} while (volba != 'K');

	}

	/**
	 * Uloen dat do souboru
	 */
	private void uloz() {
		try {
			ObjectOutputStream output = new ObjectOutputStream(
					new FileOutputStream("sklad.dat"));
			output.writeObject(sklad); // Zapi cel objekt sklad do streamu
										// Podmnkou je implementovat rozhran
										// Serializable. Vector (pedek Skladu)
										// jej implementuje automaticky a klado-
										// vou poloku jsme "donutili" my.
		} catch (Exception e) {
			System.out.println("CHYBA: Nelze uloit soubor. " + e.getMessage());
		}
	}

	/**
	 * Naten dat ze souboru pomoc ObjectInputStreamu
	 */
	private void nacti() {
		try {
			ObjectInputStream input = new ObjectInputStream(
					new FileInputStream("sklad.dat"));
			sklad = (Sklad) input.readObject(); // peti cel objekt, v naem
												// ppad kolekci sklad
		} catch (Exception e) {
			System.out.println("CHYBA: Nelze nast soubor. " + e.getMessage());
		}
	}

	/**
	 * Vyhledn poloek obsahujcch zadan etzec
	 */
	private void hledejPolozky() {
		List<SkladPolozka> v = sklad.hledej(Vstupy
				.ctiString("Zadejte hledan text: "));
		if (v != null) { // Bylo nco nalezeno?
			System.out.println("NALEZEN ZZNAMY");

			for (SkladPolozka pol : v) {
				pol.vypis(System.out);
			}
		} else {
			System.out.println("Nic nenalezeno!");
		}
	}

	public static void main(String[] args) {
		new SkladApp().start();
	}
}
