import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.ParseException;

import javax.swing.ButtonGroup;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.MaskFormatter;

public class Formular extends JPanel {
	private JLabel labelJmeno;
	private JTextField vstupJmeno;
	private JLabel labelPrijmeni;
	private JTextField vstupPrijmeni;
	private JLabel labelTelefon;
	private JFormattedTextField vstupTelefon;
	private JLabel labelDatum;
	private JFormattedTextField vstupDatum;
	private JLabel labelCas;
	private JFormattedTextField vstupCas;
	private JLabel labelKuracky;
	private JLabel labelPocetMist;

	public Formular() {
		setPreferredSize(new Dimension(400, 300));
		init();
	}


	private void init() {
		setLayout(new GridBagLayout());
		GridBagConstraints g = new GridBagConstraints();
		g.fill = GridBagConstraints.BOTH;
		g.insets = new Insets(5, 5, 5, 5); // odsazeni
		g.anchor = GridBagConstraints.FIRST_LINE_START;
		g.weightx = 10;
		g.gridwidth = 3;

		g.gridy = 0;
		labelJmeno = new JLabel("Jmno:");
		vstupJmeno = new JTextField();
		vstupJmeno.setPreferredSize(new Dimension(200, 20));
		g.gridx = 0;
		add(labelJmeno, g);
		g.gridx = 1;
		add(vstupJmeno, g);

		g.gridy = 1;
		labelPrijmeni = new JLabel("Pjmen:");
		vstupPrijmeni = new JTextField();
		vstupPrijmeni.setPreferredSize(new Dimension(200, 20));
		g.gridx = 0;
		add(labelPrijmeni, g);
		g.gridx = 1;
		add(vstupPrijmeni, g);

		g.gridy = 2;
		labelTelefon = new JLabel("Telefon:");
		MaskFormatter telefonMaska = null;
		try {
			telefonMaska = new MaskFormatter("### ### ###");
		} catch (ParseException e) {
			e.printStackTrace();
		}
		
		vstupTelefon = new JFormattedTextField(telefonMaska);
		vstupTelefon.setPreferredSize(new Dimension(200, 20));
		g.gridx = 0;
		add(labelTelefon, g);
		g.gridx = 1;
		add(vstupTelefon, g);

		g.gridy = 3;
		labelDatum = new JLabel("Datum:");
		MaskFormatter datumMaska = null;
		try {
			datumMaska = new MaskFormatter("##-##-####");
		} catch (ParseException e) {
			e.printStackTrace();
		}
		vstupDatum = new JFormattedTextField(datumMaska);
		vstupDatum.setPreferredSize(new Dimension(200, 20));
		g.gridx = 0;
		add(labelDatum, g);
		g.gridx = 1;
		add(vstupDatum, g);

		g.gridy = 4;
		labelCas = new JLabel("as:");
		MaskFormatter casMaska = null;
		try {
			casMaska = new MaskFormatter("##:##");
		} catch (ParseException e) {
			e.printStackTrace();
		}
		vstupCas = new JFormattedTextField(casMaska);
		vstupCas.setPreferredSize(new Dimension(200, 20));
		g.gridx = 0;
		add(labelCas, g);
		g.gridx = 1;
		add(vstupCas, g);

		g.gridy = 5;
		labelKuracky = new JLabel("Stl:");
		JRadioButton kuracky = new JRadioButton("kuck");
		JRadioButton nekuracky = new JRadioButton("nekuck");
		JPanel prepinac = new JPanel();
		ButtonGroup skupinaTlacitek = new ButtonGroup();
		prepinac.add(kuracky);
		skupinaTlacitek.add(kuracky);
		prepinac.add(nekuracky);
		skupinaTlacitek.add(nekuracky);
		g.gridx = 0;
		add(labelKuracky, g);
		g.gridx = 1;
		add(prepinac, g);

		g.gridy = 6;
		labelPocetMist = new JLabel("Poet mst k sezen:");
		JRadioButton dveMista = new JRadioButton("2");
		JRadioButton ctyriMista = new JRadioButton("4");
		JRadioButton sestMist = new JRadioButton("6");
		
		
		g.gridwidth = 1;
		g.gridy = 7;
		g.gridx = 0;
		add(labelPocetMist, g);
		
		ButtonGroup skupinaTlacitek2 = new ButtonGroup();
		g.gridy = 7;
		g.gridx = 1;
		skupinaTlacitek2.add(dveMista);
		skupinaTlacitek2.add(ctyriMista);
		skupinaTlacitek2.add(sestMist);
		add(dveMista, g);
		g.gridx = 2;
		add(ctyriMista, g);
		g.gridx =3;
		add(sestMist, g);
	}
}